package com.team5.aLife.Client;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.util.Log;

import com.google.gson.Gson;

public final class parseResponse {
	
	private static parseResponse thisParseResponse = new parseResponse();
	Gson gson = new Gson();
	JSONArray jsonArray = null;
	JSONObject json = null;
	ArrayList<Device> al = new ArrayList<Device>();
	ArrayList<ALifeNotificationSetup> notificationList = new ArrayList<ALifeNotificationSetup>();
	ArrayList<User> userList = new ArrayList<User>();
	
	
	private static final String TAG = "parseResponse:  ";
	
	
	public parseResponse(){
		
	}

	public static parseResponse instance(){
		return thisParseResponse;
	}
	
	@SuppressWarnings("static-access")
	public ArrayList<Device> toArrayListDevice(String in){
		try {
			
			Log.i(TAG+"toArrayListDevice", in);
			// Create a new JSONObject out of the string
			json = new JSONObject(in);
			
			// Extract the "devices" object out of the JSONObject
			json = json.getJSONObject("devices");
			
			// Extract the JSONArray out of the JSONObject
			// "myArrayList" is a default name I haven't tried to change
			// For some reason this name changes depending on what platform its 
			// running on. 
			// TODO: Give JSON Array a stable name
			if (socketDispatch.instance().simulate)
				jsonArray = json.getJSONArray("values");
			else
				jsonArray = json.getJSONArray("myArrayList");

			
			// Loop through all the devices in the JSONArray
			for (int c = 0;c < jsonArray.length(); c++){
					// Move from JSONArray to ArrayList<Device>
					al.add(gson.fromJson(jsonArray.get(c).toString(), Device.class));
			}
			
		} catch (JSONException e) {
			Log.i(TAG + "toArrayList","Errors w/ json objects" , e);
		}
				
		// Return the ArrayList
		return al;
	}
	
	public ArrayList<ALifeNotificationSetup> toArrayListNotification(String in){
		try {
			
			// Create a new JSONObject out of the string
			json = new JSONObject(in);
			
			// Extract the "devices" object out of the JSONObject
			json = json.getJSONObject("notifications");
			
			// Extract the JSONArray out of the JSONObject
			// "myArrayList" is a default name I haven't tried to change
			// For some reason this name changes depending on what platform its 
			// running on. 
			// TODO: Give JSON Array a stable name
			if (socketDispatch.instance().simulate)
				jsonArray = json.getJSONArray("values");
			else
				jsonArray = json.getJSONArray("myArrayList");

			
			// Loop through notificationListl the devices in the JSONArray
			for (int c = 0;c < jsonArray.length(); c++){
					// Move from JSONArray to ArrayList<Device>
					notificationList.add(gson.fromJson(jsonArray.get(c).toString(), ALifeNotificationSetup.class));
			}
			
		} catch (JSONException e) {
			Log.i(TAG + "toArrayList","Errors w/ json objects" , e);
		}
				
		// Return the ArrayList
		return notificationList;
	}
	
	public ArrayList<User> toArrayListUser(String in){
		try {
			
			Log.i(TAG + "toArrayList", in);
			
			// Create a new JSONObject out of the string
			json = new JSONObject(in);
			
			// Extract the "devices" object out of the JSONObject
			json = json.getJSONObject("users");
			
			// Extract the JSONArray out of the JSONObject
			// "myArrayList" is a default name I haven't tried to change
			// For some reason this name changes depending on what platform its 
			// running on. 
			// TODO: Give JSON Array a stable name
			if (socketDispatch.instance().simulate)
				jsonArray = json.getJSONArray("values");
			else
				jsonArray = json.getJSONArray("myArrayList");

			
			// Loop through userListl the devices in the JSONArray
			for (int c = 0;c < jsonArray.length(); c++){
					// Move from JSONArray to ArrayList<Device>
					userList.add(gson.fromJson(jsonArray.get(c).toString(), User.class));
			}
			
		} catch (JSONException e) {
			Log.i(TAG + "toArrayList","Errors w/ json objects" , e);
		}
				
		// Return the ArrayList
		return userList;
	}
	
}
